from typing import Optional

from dog.dog import DoG as DoGOfficialImpl

class DoG(DoGOfficialImpl):

    def __init__(self, params, reps_rel: float = 1e-6, lr: float = 1.0, weight_decay: float = 0.0, eps: float = 1e-8,
                 init_eta: Optional[float] = None):

        super().__init__(params, reps_rel, lr, weight_decay, eps, init_eta)

    def has_d_estimator(self):
        return True

    def calculate_d_estimation_error(self, actual_d):
        return actual_d / self.param_groups[0]['rbar']
